/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.dao;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;

import jp.mosp.human.dao.MKihonDao;
import jp.mosp.kintai.dto.MSyukkinboDto;

public class MSyukkinboDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE  = "M_SYUKKINBO";
	public static final String KEY_1  = "KCODE";		//ЈR[h
	public static final String KEY_2  = "HIZUKE";		//t

	// 
	public static final String COL_KCODE  		= "KCODE";		//ЈR[h
	public static final String COL_HIZUKE  		= "HIZUKE";		//t
	public static final String COL_NEN  			= "NEN";		//N
	public static final String COL_TUKI  			= "TUKI";		//
	public static final String COL_HI  			= "HI";			//
	public static final String COL_SYOZOKU  		= "SYOZOKU";	//R[h
	public static final String COL_NINSYO  		= "NINSYO";		//F؎
	public static final String COL_SYJIKOKU  		= "SYJIKOKU";	//oΎ
	public static final String COL_KINMU  		= "KINMU";		//Ζ`
	public static final String COL_SHANKYUKB  	= "SHANKYUKB";	//x敪
	public static final String COL_KYUSYUKB  		= "KYUSYUKB";	//xo敪
	public static final String COL_TIRIYUU  		= "TIRIYUU";	//xR
	public static final String COL_TICOMENT  		= "TICOMENT";	//xRg
	public static final String COL_TISYOUMEI  	= "TISYOUMEI";	//xؖ
	public static final String COL_TIJIKAN  		= "TIJIKAN";	//x
	public static final String COL_SYTIMES  		= "SYTIMES";	//oΓ͓
	public static final String COL_TAJIKOKU  		= "TAJIKOKU";	//ގЎ
	public static final String COL_KINMUJI  		= "KINMUJI";	//Ζ
	public static final String COL_KYUKEIJI 	 	= "KYUKEIJI";	//xe
	public static final String COL_THANKYUKB  	= "THANKYUKB";	//x敪
	public static final String COL_SORIYUU  		= "SORIYUU";	//ޗR
	public static final String COL_SOCOMENT  		= "SOCOMENT";	//ރRg
	public static final String COL_SOSYOUMEI  	= "SOSYOUMEI";	//ޏؖ
	public static final String COL_SOJIKAN  		= "SOJIKAN";	//ގ
	public static final String COL_ZAJIKAN  		= "ZAJIKAN";	//cƎ
	public static final String COL_KSJIKAN  		= "KSJIKAN";	//xo
	public static final String COL_SNJIKAN  		= "SNJIKAN";	//[鎞
	public static final String COL_SYOKUJI  		= "SYOKUJI";	//H蓖x
	public static final String COL_CYOKU1  		= "CYOKU1";		//1蓖x
	public static final String COL_CYOKU2  		= "CYOKU2";		//2蓖x
	public static final String COL_CYOKU3  		= "CYOKU3";		//3蓖x
	public static final String COL_HOKA1  		= "HOKA1";		//̑x1
	public static final String COL_HOKA2 			= "HOKA2";		//̑x2
	public static final String COL_HOKA3  		= "HOKA3";		//̑x3
	public static final String COL_HOKA4  		= "HOKA4";		//̑x4
	public static final String COL_HOKA5  		= "HOKA5";		//̑x5
	public static final String COL_TATIMES  		= "TATIMES";	//ގГ͓
	public static final String COL_KKRIYUU  		= "KKRIYUU";	//xɗR
	public static final String COL_DAIKYUJYU  	= "DAIKYUJYU";	//x[
	public static final String COL_KKCOMENT  		= "KKCOMENT";	//xɃRg
	public static final String COL_KKSYOUMEI  	= "KKSYOUMEI";	//xɏؖ
	public static final String COL_KKJIKAN  		= "KKJIKAN";	//xɎ
	public static final String COL_KKTIMES  		= "KKTIMES";	//xɓ͓
	public static final String COL_SNRIYUU  		= "SNRIYUU";	//FR
	public static final String COL_SNCOMENT  		= "SNCOMENT";	//FRg
	public static final String COL_SNTIMES  		= "SNTIMES";	//F͓
	public static final String COL_UPDATETIMES  	= "UPDTTIMES";	//XV
	public static final String COL_NIJIKYU  		= "NIJIKYU";	//񎞊ԔNx

	/**
	 * RXgN^
	 */
	public MSyukkinboDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<MSyukkinboDto> mappingAll() throws SQLException {
		List<MSyukkinboDto> all = new ArrayList<MSyukkinboDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_syukkinboDto m_syukkinboR[h
	 * @throws SQLException
	 */
	private MSyukkinboDto mapping() throws SQLException {
		MSyukkinboDto dto = new MSyukkinboDto();
		dto.setKCode 		(rs.getString (COL_KCODE));			//ЈR[h
		dto.setHizuke 		(rs.getString (COL_HIZUKE));		//t
		dto.setNen 			(rs.getInt    (COL_NEN));			//N
		dto.setTuki 		(rs.getInt    (COL_TUKI));			//
		dto.setHi 			(rs.getInt    (COL_HI));			//
		dto.setSyozoku 		(rs.getString (COL_SYOZOKU));		//R[h
		dto.setNinsyo 		(rs.getString (COL_NINSYO));		//F؎
		dto.setSyJikoku 	(rs.getString (COL_SYJIKOKU));		//oΎ
		dto.setKinmu 		(rs.getString (COL_KINMU));			//Ζ`
		dto.setSHankyuKb 	(rs.getString (COL_SHANKYUKB));		//x敪
		dto.setKyusyuKb 	(rs.getString (COL_KYUSYUKB));		//xo敪
		dto.setTiRiyuu 		(rs.getString (COL_TIRIYUU));		//xR
		dto.setTiComent 	(rs.getString (COL_TICOMENT));		//xRg
		dto.setTiSyoumei 	(rs.getString (COL_TISYOUMEI));		//xؖ
		dto.setTiJikan 		(rs.getInt    (COL_TIJIKAN));		//x
		dto.setSyTimes 		(rs.getString (COL_SYTIMES));		//oΓ͓
		dto.setTaJikoku 	(rs.getString (COL_TAJIKOKU));		//ގЎ
		dto.setKinmuJi 		(rs.getInt    (COL_KINMUJI));		//Ζ
		dto.setKyukeiJi 	(rs.getInt    (COL_KYUKEIJI));		//xe
		dto.setTHankyuKb	(rs.getString (COL_THANKYUKB));		//x敪
		dto.setSoRiyuu 		(rs.getString (COL_SORIYUU));		//ޗR
		dto.setSoComent 	(rs.getString (COL_SOCOMENT));		//ރRg
		dto.setSoSyoumei 	(rs.getString (COL_SOSYOUMEI));		//ޏؖ
		dto.setSoJikan 		(rs.getInt    (COL_SOJIKAN));		//ގ
		dto.setZaJikan 		(rs.getInt    (COL_ZAJIKAN));		//cƎ
		dto.setKsJikan 		(rs.getInt    (COL_KSJIKAN));		//xo
		dto.setSnJikan 		(rs.getInt    (COL_SNJIKAN));		//[鎞
		dto.setSyokuji 		(rs.getInt    (COL_SYOKUJI));		//H蓖x
		dto.setCyoku1 		(rs.getInt    (COL_CYOKU1));		//1蓖x
		dto.setCyoku2 		(rs.getInt    (COL_CYOKU2));		//2蓖x
		dto.setCyoku3 		(rs.getInt    (COL_CYOKU3));		//3蓖x
		dto.setHoka1 		(rs.getInt    (COL_HOKA1));			//̑x1
		dto.setHoka2 		(rs.getInt    (COL_HOKA2));			//̑x2
		dto.setHoka3 		(rs.getInt    (COL_HOKA3));			//̑x3
		dto.setHoka4 		(rs.getInt    (COL_HOKA4));			//̑x4
		dto.setHoka5 		(rs.getInt    (COL_HOKA5));			//̑x5
		dto.setTaTimes 		(rs.getString (COL_TATIMES));		//ގГ͓
		dto.setKKRiyuu 		(rs.getString (COL_KKRIYUU));		//xɗR
		dto.setDaiKyuJyu 	(rs.getString (COL_DAIKYUJYU));		//x[
		dto.setKKComent 	(rs.getString (COL_KKCOMENT));		//xɃRg
		dto.setKKSyoumei 	(rs.getString (COL_KKSYOUMEI));		//xɏؖ
		dto.setKKJikan 		(rs.getInt    (COL_KKJIKAN));		//xɎ
		dto.setKKTimes 		(rs.getString (COL_KKTIMES));		//xɓ͓
		dto.setSnRiyuu 		(rs.getString (COL_SNRIYUU));		//FR
		dto.setSnComent 	(rs.getString (COL_SNCOMENT));		//FRg
		dto.setSnTimes 		(rs.getString (COL_SNTIMES));		//F͓
		dto.setUpdtTimes 	(rs.getString (COL_UPDATETIMES));	//XV
		dto.setNijiKyu		(rs.getInt	  (COL_NIJIKYU));		//񎞊ԔNx
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @param hizuke t(L[)
	 * @return m_syukkinboDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MSyukkinboDto findForKey(
			String kcode,
			String hizuke
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, hizuke);
			executeQuery();
			MSyukkinboDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param hizuke t(L[)
	 * @return m_syukkinboDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MSyukkinboDto findForUpdate(
			String kcode,
			String hizuke
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, hizuke);
			executeQuery();
			MSyukkinboDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param hizuke t
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MSyukkinboDto> findForCondition(
			String kcode,
			String hizuke
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_HIZUKE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   kcode  );
			setParam(index++,   hizuke   + "%");
			executeQuery();
			List<MSyukkinboDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode 		ЈR[h
	 * @param startDate 	Jnt
	 * @param endDate 		It
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MSyukkinboDto> findForAttendanceList(
			String kcode,
			String startDate,
			String endDate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" = ? AND ");
		sb.append(COL_HIZUKE);
		sb.append(" >= ? AND ");
		sb.append(COL_HIZUKE);
		sb.append(" <= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,	kcode);
			setParam(index++,	startDate);
			setParam(index++,	endDate);
			executeQuery();
			List<MSyukkinboDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param date		t
	 * @param kCode		ЈR[h
	 * @param kName		Ј
	 * @param approval	F
	 * @return m_syukkinboDto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MSyukkinboDto findForDayApproval(
			String	date,
			String  kCode,
			String	kName,
			String 	approval
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_HIZUKE);
		sb.append(" = ? ");
		if (!kCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_KCODE);
			sb.append(" LIKE ? ");			
		}
		if (!kName.equals("")) {
			sb.append(" AND ");
			sb.append(	" ( ");
			sb.append(		COL_KCODE + " IN (" + MKihonDao.getSearchKNameSubQuery() + ") ");				
			sb.append(	" ) ");
		}
		if (!approval.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SNRIYUU);
			sb.append(" LIKE ? ");			
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, date	);
			if (!kCode.equals("")) {
				setParam(index++, "%" + kCode + "%" );
			}
			if (!kName.equals("")) {
				setParam(index++,  "%" + kName + "%" );
			}
			if (!approval.equals("")) {
				setParam(index++,  approval );
			}
			executeQuery();
			MSyukkinboDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * suml擾
	 * @param kcode ЈR[h
	 * @param startdate Jnt
	 * @param enddate It
	 * @return v
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public int findForSum(
			String kcode,
			String startdate,
			String enddate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			int sumOverTime = 0;
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT SUM(");
			sb.append(COL_ZAJIKAN);
			sb.append(") FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_KCODE);
			sb.append(" = ? AND ? <= ");
			sb.append(COL_HIZUKE);
			sb.append(" AND ");
			sb.append(COL_HIZUKE);
			sb.append(" <= ? ");
			prepareStatement(sb.toString());
			setParam(index++, kcode);
			setParam(index++, startdate);
			setParam(index++, enddate);
			executeQuery();
			if (rs.next()) {
				sumOverTime = rs.getInt(1);
			}
			return sumOverTime;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MSyukkinboDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}ioΓ́j
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insertStart(MSyukkinboDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("INSERT INTO ");
			sb.append(TABLE);
			sb.append(" (");
			sb.append(COL_KCODE 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_HIZUKE 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_NEN 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_TUKI 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_HI 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_SYOZOKU	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_SYJIKOKU 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_KINMU 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_SHANKYUKB + MospConst.DATA_SEPARATOR);
			sb.append(COL_KYUSYUKB 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_TIRIYUU 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_TICOMENT 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_TISYOUMEI + MospConst.DATA_SEPARATOR);
			sb.append(COL_TIJIKAN 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_SYTIMES 	+ MospConst.DATA_SEPARATOR);
			sb.append(INSERT_DATE 	+ MospConst.DATA_SEPARATOR);
			sb.append(INSERT_USER	+ MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_DATE 	+ MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_USER 	);
			sb.append(") VALUES(");
			for (int i = 0; i < 18; i++) {
				sb.append(" ?,");
			}
			sb.append(" ?)");		
			prepareStatement(sb.toString());
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getHizuke());
			setParam(index++, dto.getNen());
			setParam(index++, dto.getTuki());
			setParam(index++, dto.getHi());
			setParam(index++, dto.getSyozoku());			
			setParam(index++, dto.getSyJikoku());
			setParam(index++, dto.getKinmu());
			setParam(index++, dto.getSHankyuKb());
			setParam(index++, dto.getKyusyuKb());
			setParam(index++, dto.getTiRiyuu());
			setParam(index++, dto.getTiComent());
			setParam(index++, dto.getTiSyoumei());
			setParam(index++, dto.getTiJikan());
			setParam(index++, dto.getSyTimes());
			setCommonParams(true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}ixɓ́j
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insertHoliday(MSyukkinboDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("INSERT INTO ");
			sb.append(TABLE);
			sb.append(" (");
			sb.append(COL_KCODE 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_HIZUKE 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_NEN 			+ MospConst.DATA_SEPARATOR);
			sb.append(COL_TUKI 			+ MospConst.DATA_SEPARATOR);
			sb.append(COL_HI 			+ MospConst.DATA_SEPARATOR);
			sb.append(COL_SYOZOKU		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_KINMU 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_KKRIYUU 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_DAIKYUJYU 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_KKCOMENT 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_KKSYOUMEI 	+ MospConst.DATA_SEPARATOR);
			sb.append(COL_KKJIKAN 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_KKTIMES 		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_SNRIYUU		+ MospConst.DATA_SEPARATOR);
			sb.append(COL_UPDATETIMES 	+ MospConst.DATA_SEPARATOR);	
			sb.append(INSERT_DATE 		+ MospConst.DATA_SEPARATOR);
			sb.append(INSERT_USER		+ MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_DATE 		+ MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_USER 		);
			sb.append(") VALUES(");
			for (int i = 0; i < 18; i++) {
				sb.append(" ?,");
			}
			sb.append(" ?)");		
			prepareStatement(sb.toString());
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getHizuke());
			setParam(index++, dto.getNen());
			setParam(index++, dto.getTuki());
			setParam(index++, dto.getHi());
			setParam(index++, dto.getSyozoku());			
			setParam(index++, dto.getKinmu());
			setParam(index++, dto.getKKRiyuu());
			setParam(index++, dto.getDaiKyuJyu());
			setParam(index++, dto.getKKComent());
			setParam(index++, dto.getKKSyoumei());
			setParam(index++, dto.getKKJikan());
			setParam(index++, dto.getKKTimes());
			setParam(index++, dto.getSnRiyuu());
			setParam(index++, dto.getUpdtTimes());
			setCommonParams(true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param 	aryDto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MSyukkinboDto[] aryDto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("INSERT INTO ");
			sb.append(TABLE);
			sb.append("(");
			Field[] fields = getClass().getFields();
			for (int i = 0; i < fields.length; i++) {
				Field field = fields[i];
				String name = field.getName();
				if (name.indexOf("COL_") == 0) {
					sb.append(field.get(null));
					sb.append(", ");
				}
			}
			if (!INSERT_DATE.equals("")) {
				sb.append(INSERT_DATE + ", ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append(INSERT_USER + ", ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + ", ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + ", ");
			}
			sb.delete(sb.length() - 2, sb.length() - 1);
			sb.append(") VALUES");
			for (int a = 0; a < aryDto.length; a++) {
				sb.append("(");
				for (int i = 0; i < fields.length; i++) {
					Field field = fields[i];
					String name = field.getName();
					if (name.indexOf("COL_") == 0) {
						sb.append("?, ");
					}
				}
				if (!INSERT_DATE.equals("")) {
					sb.append("?, ");
				}
				if (!INSERT_USER.equals("")) {
					sb.append("?, ");
				}
				if (!UPDATE_DATE.equals("")) {
					sb.append("?, ");
				}
				if (!UPDATE_USER.equals("")) {
					sb.append("?, ");
				}
				sb.delete(sb.length() - 2, sb.length());
				sb.append("),");
			}
			sb.delete(sb.length() - 1, sb.length());
			prepareStatement(sb.toString());
			for (int d = 0; d < aryDto.length; d++) {
				setParams(aryDto[d], true);
			}
			executeUpdate();
			chkInsert(aryDto.length);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XVioΓ́j
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int updateStart(MSyukkinboDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("UPDATE ");
			sb.append(TABLE);
			sb.append(" SET ");
			sb.append(COL_SYJIKOKU 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_KINMU 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_SHANKYUKB + " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_KYUSYUKB 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_TIRIYUU 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_TICOMENT 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_TISYOUMEI + " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_TIJIKAN 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_SYTIMES 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_DATE 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_USER 	+ " =?"	);
			sb.append(" WHERE ");
			sb.append(COL_KCODE + " =?");
			sb.append(" AND ");
			sb.append(COL_HIZUKE + " =?");
			prepareStatement(sb.toString());
			setParam(index++, dto.getSyJikoku());
			setParam(index++, dto.getKinmu());
			setParam(index++, dto.getSHankyuKb());
			setParam(index++, dto.getKyusyuKb());
			setParam(index++, dto.getTiRiyuu());
			setParam(index++, dto.getTiComent());
			setParam(index++, dto.getTiSyoumei());
			setParam(index++, dto.getTiJikan());
			setParam(index++, dto.getSyTimes());
			setCommonParams(false);
			// L[
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getHizuke());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XViދΓ́j
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int updateQuit(MSyukkinboDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("UPDATE ");
			sb.append(TABLE);
			sb.append(" SET ");
			sb.append(COL_TAJIKOKU 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_KINMUJI 		+ " =?" + MospConst.DATA_SEPARATOR);			
			sb.append(COL_KYUKEIJI 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_THANKYUKB 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_SORIYUU 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_SOCOMENT 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_SOSYOUMEI 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_SOJIKAN 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_ZAJIKAN 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_KSJIKAN 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_SNJIKAN 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_SYOKUJI 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_CYOKU1 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_CYOKU2 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_CYOKU3 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_HOKA1 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_HOKA2 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_HOKA3 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_HOKA4 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_HOKA5 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_TATIMES 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_SNRIYUU 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_UPDATETIMES 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_DATE 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_USER 		+ " =?"	);
			sb.append(" WHERE ");
			sb.append(COL_KCODE + " =?");
			sb.append(" AND ");
			sb.append(COL_HIZUKE + " =?");
			prepareStatement(sb.toString());
			setParam(index++, dto.getTaJikoku());
			setParam(index++, dto.getKinmuJi());
			setParam(index++, dto.getKyukeiJi());
			setParam(index++, dto.getTHankyuKb());
			setParam(index++, dto.getSoRiyuu());
			setParam(index++, dto.getSoComent());
			setParam(index++, dto.getSoSyoumei());
			setParam(index++, dto.getSoJikan());
			setParam(index++, dto.getZaJikan());
			setParam(index++, dto.getKsJikan());
			setParam(index++, dto.getSnJikan());
			setParam(index++, dto.getSyokuji());
			setParam(index++, dto.getCyoku1());
			setParam(index++, dto.getCyoku2());
			setParam(index++, dto.getCyoku3());
			setParam(index++, dto.getHoka1());
			setParam(index++, dto.getHoka2());
			setParam(index++, dto.getHoka3());
			setParam(index++, dto.getHoka4());
			setParam(index++, dto.getHoka5());
			setParam(index++, dto.getTaTimes());
			setParam(index++, dto.getSnRiyuu());
			setParam(index++, dto.getUpdtTimes());
			setCommonParams(false);
			// L[
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getHizuke());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XVixɓ́j
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int updateHoliday(MSyukkinboDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("UPDATE ");
			sb.append(TABLE);
			sb.append(" SET ");
			sb.append(COL_KKRIYUU 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_DAIKYUJYU 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_KKCOMENT 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_KKSYOUMEI 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_KKJIKAN 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_KKTIMES 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(COL_UPDATETIMES 	+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_DATE 		+ " =?" + MospConst.DATA_SEPARATOR);
			sb.append(UPDATE_USER 		+ " =?"	);
			sb.append(" WHERE ");
			sb.append(COL_KCODE + " =?");
			sb.append(" AND ");
			sb.append(COL_HIZUKE + " =?");
			prepareStatement(sb.toString());
			setParam(index++, dto.getKKRiyuu());
			setParam(index++, dto.getDaiKyuJyu());
			setParam(index++, dto.getKKComent());
			setParam(index++, dto.getKKSyoumei());
			setParam(index++, dto.getKKJikan());
			setParam(index++, dto.getKKTimes());
			setParam(index++, dto.getUpdtTimes());
			setCommonParams(false);
			// L[
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getHizuke());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MSyukkinboDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto,false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getHizuke());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MSyukkinboDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getHizuke());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MSyukkinboDto dto,boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode());		//ЈR[h
		setParam(index++, dto.getHizuke());		//t
		setParam(index++, dto.getNen());		//N
		setParam(index++, dto.getTuki());		//
		setParam(index++, dto.getHi());			//
		setParam(index++, dto.getSyozoku());	//R[h
		setParam(index++, dto.getNinsyo());		//F؎
		setParam(index++, dto.getSyJikoku());	//oΎ
		setParam(index++, dto.getKinmu());		//Ζ`
		setParam(index++, dto.getSHankyuKb());	//x敪
		setParam(index++, dto.getKyusyuKb());	//xo敪
		setParam(index++, dto.getTiRiyuu());	//xR
		setParam(index++, dto.getTiComent());	//xRg
		setParam(index++, dto.getTiSyoumei());	//xؖ
		setParam(index++, dto.getTiJikan());	//x
		setParam(index++, dto.getSyTimes());	//oΓ͓
		setParam(index++, dto.getTaJikoku());	//ގЎ
		setParam(index++, dto.getKinmuJi());	//Ζ
		setParam(index++, dto.getKyukeiJi());	//xe
		setParam(index++, dto.getTHankyuKb());	//x敪
		setParam(index++, dto.getSoRiyuu());	//ޗR
		setParam(index++, dto.getSoComent());	//ރRg
		setParam(index++, dto.getSoSyoumei());	//ޏؖ
		setParam(index++, dto.getSoJikan());	//ގ
		setParam(index++, dto.getZaJikan());	//cƎ
		setParam(index++, dto.getKsJikan());	//xo
		setParam(index++, dto.getSnJikan());	//[鎞
		setParam(index++, dto.getSyokuji());	//H蓖x
		setParam(index++, dto.getCyoku1());		//1蓖x
		setParam(index++, dto.getCyoku2());		//2蓖x
		setParam(index++, dto.getCyoku3());		//3蓖x
		setParam(index++, dto.getHoka1());		//̑x1
		setParam(index++, dto.getHoka2());		//̑x2
		setParam(index++, dto.getHoka3());		//̑x3
		setParam(index++, dto.getHoka4());		//̑x4
		setParam(index++, dto.getHoka5());		//̑x5
		setParam(index++, dto.getTaTimes());	//ގГ͓
		setParam(index++, dto.getKKRiyuu());	//xɗR
		setParam(index++, dto.getDaiKyuJyu());	//x[
		setParam(index++, dto.getKKComent());	//xɃRg
		setParam(index++, dto.getKKSyoumei());	//xɏؖ
		setParam(index++, dto.getKKJikan());	//xɎ
		setParam(index++, dto.getKKTimes());	//xɓ͓
		setParam(index++, dto.getSnRiyuu());	//FR
		setParam(index++, dto.getSnComent());	//FRg
		setParam(index++, dto.getSnTimes());	//F͓
		setParam(index++, dto.getUpdtTimes());	//XV
		setParam(index++, dto.getNijiKyu());	//񎞊ԔNx
		setCommonParams(isInsert);
	}

}
